% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procrustes.R
\name{calculate_procrustes_significance}
\alias{calculate_procrustes_significance}
\title{Calculate Statistical Significance Between Maps Using Procrustes Analysis}
\usage{
calculate_procrustes_significance(map1, map2)
}
\arguments{
\item{map1}{Data frame with coordinates from first map (must have X, X.1 columns)}

\item{map2}{Data frame with coordinates from second map (must have X, X.1 columns)}
}
\value{
A single numeric p-value from the Procrustes permutation test.
}
\description{
Performs Procrustes analysis between two maps and calculates statistical
significance of their differences using permutation tests. Handles common
data cleaning steps like removing missing values and ensuring comparable
point sets.
}
\examples{
# Create sample map data
map1 <- data.frame(name = letters[1:10], X = rnorm(10), X.1 = rnorm(10))
map2 <- data.frame(name = letters[1:10], X = rnorm(10), X.1 = rnorm(10))
p_val <- calculate_procrustes_significance(map1, map2)
}
