% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{generate_complex_data}
\alias{generate_complex_data}
\title{Generate Complex High-Dimensional Data for Testing}
\usage{
generate_complex_data(
  n_points = 500,
  n_dim = 10,
  n_clusters = 4,
  cluster_spread = 1,
  fig_name = NA
)
}
\arguments{
\item{n_points}{Integer number of points to generate}

\item{n_dim}{Integer number of dimensions}

\item{n_clusters}{Integer number of clusters}

\item{cluster_spread}{Numeric controlling cluster variance}

\item{fig_name}{Character path to save visualization (optional)}
}
\value{
A \code{data.frame} with \code{n_points} rows and \code{n_dim} columns. Column names
are "Dim1" through "DimN" where N is n_dim.
}
\description{
Generates synthetic high-dimensional data with clusters and trends for testing
dimensionality reduction methods. Creates data with specified properties:
\itemize{
\item Multiple clusters along a trend line
\item Variable density regions
\item Controllable noise levels
\item Optional visualization
}

The function generates cluster centers along a trend line, adds points around those
centers with specified spread, and incorporates random noise to create high and
low density areas. The data is useful for testing dimensionality reduction and
visualization methods.
}
\examples{
# Generate basic dataset
data <- generate_complex_data(n_points = 500, n_dim = 10, 
                             n_clusters = 4, cluster_spread = 1)
                             
# The function returns a data frame, which can be inspected
head(data)

}
