% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_triplet_margin_loss}
\alias{nn_triplet_margin_loss}
\title{Triplet margin loss}
\usage{
nn_triplet_margin_loss(
  margin = 1,
  p = 2,
  eps = 1e-06,
  swap = FALSE,
  reduction = "mean"
)
}
\arguments{
\item{margin}{(float, optional): Default: \eqn{1}.}

\item{p}{(int, optional): The norm degree for pairwise distance. Default: \eqn{2}.}

\item{eps}{constant to avoid NaN's}

\item{swap}{(bool, optional): The distance swap is described in detail in the paper
\href{https://paperswithcode.com/paper/learning-local-feature-descriptors-with}{Learning shallow convolutional feature descriptors with triplet losses} by
V. Balntas, E. Riba et al. Default: \code{FALSE}.}

\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed.}
}
\description{
Creates a criterion that measures the triplet loss given an input
tensors \eqn{x1}, \eqn{x2}, \eqn{x3} and a margin with a value greater than \eqn{0}.
This is used for measuring a relative similarity between samples. A triplet
is composed by \code{a}, \code{p} and \code{n} (i.e., \code{anchor}, \verb{positive examples} and \verb{negative examples} respectively). The shapes of all input tensors should be
\eqn{(N, D)}.
}
\details{
The distance swap is described in detail in the paper
\href{https://paperswithcode.com/paper/learning-local-feature-descriptors-with}{Learning shallow convolutional feature descriptors with triplet losses} by
V. Balntas, E. Riba et al.

The loss function for each sample in the mini-batch is:

\deqn{
  L(a, p, n) = \max \{d(a_i, p_i) - d(a_i, n_i) + {\rm margin}, 0\}
}

where

\deqn{
  d(x_i, y_i) = | {\bf x}_i - {\bf y}_i |_p
}

See also \code{\link[=nn_triplet_margin_with_distance_loss]{nn_triplet_margin_with_distance_loss()}}, which computes the
triplet margin loss for input tensors using a custom distance function.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, D)} where \eqn{D} is the vector dimension.
\item Output: A Tensor of shape \eqn{(N)} if \code{reduction} is \code{'none'}, or a scalar
otherwise.
}
}

\examples{
if (torch_is_installed()) {
triplet_loss <- nn_triplet_margin_loss(margin = 1, p = 2)
anchor <- torch_randn(100, 128, requires_grad = TRUE)
positive <- torch_randn(100, 128, requires_grad = TRUE)
negative <- torch_randn(100, 128, requires_grad = TRUE)
output <- triplet_loss(anchor, positive, negative)
output$backward()
}
}
