% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subscribed_metadata.R
\name{get_subscribed_metadata}
\alias{get_subscribed_metadata}
\title{Get metadata for subscribed NHS TRUD items}
\usage{
get_subscribed_metadata(TRUD_API_KEY = NULL, latest_only = FALSE)
}
\arguments{
\item{TRUD_API_KEY}{A string. The name of an environmental variable
containing your TRUD API key. If \code{NULL} (default) this is assumed to be
called \code{TRUD_API_KEY}.}

\item{latest_only}{If \code{TRUE}, only metadata pertaining to the latest item
release will be retrieved. By default this is set to \code{FALSE}.}
}
\value{
A tibble, with item metadata stored in the list column \code{metadata}.
}
\description{
A convenience wrapper around \code{\link[=trud_items]{trud_items()}} and \code{\link[=get_item_metadata]{get_item_metadata()}},
retrieving metadata for only items that the user is subscribed to.
}
\examples{
\dontrun{
get_subscribed_metadata()
}
}
\seealso{
\code{\link[=trud_items]{trud_items()}}, \code{\link[=get_item_metadata]{get_item_metadata()}}
}
