% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_data_DESN025.R
\docType{data}
\name{sample_data_DESN025}
\alias{sample_data_DESN025}
\title{Environmental Data for Modelling from station DESN025 in Leipzig-Mitte.}
\format{
A data table with the following columns:
\describe{
\item{Station}{Station identifier where the data was collected.}
\item{Komponente}{The environmental component being measured
(e.g., temperature, NO2).}
\item{Wert}{The measured value of the component.}
\item{date}{The timestamp for the observation, formatted as a Date-Time
object in the format
\code{"YYYY-MM-DD HH:MM:SS"} (e.g., "2010-01-01 07:00:00").}
\item{Komponente_txt}{A textual description or label for the component.}
}

The dataset is structured in a long format and is prepared for further
transformation into a wide format for modelling.
}
\source{
Sächsisches Landesamt für Umwelt, Landwirtschaft und Geologie (LfULG).
}
\usage{
sample_data_DESN025
}
\description{
This dataset contains environmental measurements from the Leipzig Mitte
station provided by the Sächsisches Landesamt für Umwelt,
Landwirtschaft und Geologie (LfULG). Alterations in the data: Codes for
incorrect values have been removed.
}
\details{
The dataset is licensed under the "Data Licence Germany – attribution – version 2.0 (DL-DE-BY-2.0)".
(1) Any use will be permitted provided it fulfils the requirements of this "Data licence Germany – attribution – Version 2.0".

The data and meta-data provided may, for commercial and non-commercial use, in particular
\itemize{
\item be copied, printed, presented, altered, processed and transmitted to third parties;
\item be merged with own data and with the data of others and be combined to form new and independent datasets;
\item be integrated in internal and external business processes, products and applications in public and non-public electronic networks.
}
(2) The user must ensure that the source note contains the following information:
\itemize{
\item the name of the provider,
\item the annotation "Data licence Germany – attribution – Version 2.0" or "dl-de/by-2-0" referring to the licence text available at www.govdata.de/dl-de/by-2-0, and
\item a reference to the dataset (URI).
}
This applies only if the entity keeping the data provides the pieces of information 1-3 for the source note.

(3) Changes, editing, new designs or other amendments must be marked as such in the source note.

For more information on the license, visit \url{https://www.govdata.de/dl-de/by-2-0}.
}
\examples{
\donttest{
data(sample_data_DESN025)
params <- load_params()
dt_prepared <- prepare_data_for_modelling(sample_data_DESN025, params)
}
}
\keyword{datasets}
