% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{patch_metadata}
\alias{patch_metadata}
\title{Fix Missing or Incorrect Athlete Demographics}
\usage{
patch_metadata(
  data,
  patch_file,
  patch_sheet = 1,
  id_col = "profileId",
  fields_to_patch = c("sex", "dateOfBirth"),
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame. Master metadata or analysis dataset.}

\item{patch_file}{Character. Path to Excel (.xlsx) or CSV (.csv) file
containing corrections.}

\item{patch_sheet}{Character or integer. For Excel files, which sheet to read.
Default is 1 (first sheet).}

\item{id_col}{Character. Name of the ID column in both \code{data} and
\code{patch_file}. Default is "profileId".}

\item{fields_to_patch}{Character vector. Column names to update from the
patch file. Default is c("sex", "dateOfBirth").}

\item{verbose}{Logical. If TRUE, prints progress messages. Default is TRUE.}
}
\value{
Data frame with patched metadata.
}
\description{
Allows users to provide an external Excel or CSV file containing corrected
demographic information (e.g., sex, date of birth) for athletes with missing
or incorrect data in the VALD system. This function merges the corrections
and updates the master metadata.
}
\details{
Patch Missing Metadata from External File
}
\examples{
\donttest{
if (FALSE) {
  # Create an Excel file with columns: profileId, sex, dateOfBirth
  # Then patch the metadata
  patched_data <- patch_metadata(
    data = athlete_metadata,
    patch_file = "corrections.xlsx",
    fields_to_patch = c("sex", "dateOfBirth")
  )

  # Check results
  table(patched_data$sex)
}
}
}
