\name{brier}
       \alias{brier}
       \title{Brier Score}
       \description{Calculates verification statistics for
     probabilistic forecasts of binary events.}
       \usage{
    brier(obs, pred, baseline, thresholds = seq(0,1,0.1), bins = TRUE, \dots )
       }
      \arguments{
    \item{obs}{Vector of binary observations }
    \item{pred}{Vector of probablistic predictions [0,1] }
    \item{baseline}{Vector of climatological (no - skill) forecasts. If
      this is null, a sample climatology will be calculated.}
    \item{thresholds}{Values used to bin the forecasts.  By default the
      bins are \{[0,0.1), [0.1, 0.2), ....\} .}
    \item{bins}{If TRUE, thresholds define bins
      into which the probablistic forecasts are entered and assigned
      the midpoint as a forecast.  Otherwise, each unique forecast is considered as a 
      seperate forecast.  For example, set bins to FALSE when dealing with a finite number of 
      probabilities generated by an ensemble forecast.}
    \item{\dots}{Optional arguments}
       }
       \value{
     \item{baseline.tf}{Logical indicator of whether climatology was
       provided.}
     \item{bs}{Brier score}
     \item{bs.baseline}{Brier Score for climatology}
     \item{ss}{Skill score}
     \item{bs.reliability}{Reliability portion of Brier score.}
     \item{bs.resolution}{Resolution component of Brier score.}
     \item{bs.uncert}{Uncertainty component of Brier score.}
     \item{y.i}{Forecast bins -- described as the center value of
       the bins.}
     \item{obar.i}{Observation bins -- described as the center value
     of the bins.}
     \item{prob.y}{Proportion of time using each forecast}
     \item{obar}{Forecast based on climatology or average sample
       observations.}
     \item{check}{ Reliability - resolution + uncertainty should
       equal brier score.}
     }
       \note{This function is used within \code{verify}.}
     \examples{

#  probabilistic/ binary example

pred<- runif(100)
obs<- round(runif(100))
brier(obs, pred)

}


\references{
  Wilks, D. S. (1995) \emph{Statistical Methods in the Atmospheric Sciences }
  Chapter 7, San Diego: Academic Press.
}
\author{Matt Pocernich}

       \keyword{file}
