% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingThemes.R
\name{themeVisOmop}
\alias{themeVisOmop}
\title{Apply a pre-defined visOmopResults theme to a ggplot}
\usage{
themeVisOmop(style = NULL, fontsizeRef = NULL)
}
\arguments{
\item{style}{Visual theme to apply. Character, or \code{NULL}.
If a character, this may be either the name of a built-in style
(see \code{plotStyle()}), or a path to a \code{.yml} file that
defines a custom style. If \code{NULL}, the function will use the
explicit default style, unless a global style option is
set (see \code{setGlobalPlotOptions()}), or a \verb{_brand.yml} file is present
(in that order).
Refer to the package vignette on styles to learn more.}

\item{fontsizeRef}{An integer to use as reference when adjusting label
fontsize.}
}
\description{
Apply a pre-defined visOmopResults theme to a ggplot
}
\examples{
result <- mockSummarisedResult() |> dplyr::filter(variable_name == "age")

barPlot(
  result = result,
  x = "cohort_name",
  y = "mean",
  facet = c("age_group", "sex"),
  colour = "sex") +
 themeVisOmop()
}
