% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life_table.R
\name{life_table}
\alias{life_table}
\title{Compute period lifetables from age-specific mortality rates}
\usage{
life_table(.data, mortality)
}
\arguments{
\item{.data}{A \code{vital} including an age variable and a variable containing mortality rates.}

\item{mortality}{Variable in \code{.data} containing Mortality rates (mx). If omitted, the variable with name  \code{mx}, \code{Mortality} or \code{Rate} will be used (not case sensitive).}
}
\value{
A vital object containing the index, keys, and the new life table variables \code{mx}, \code{qx}, \code{lx}, \code{dx}, \code{Lx}, \code{Tx} and \code{ex}.
}
\description{
All available years and ages are included in the tables.
$qx = mx/(1 + ((1-ax) * mx))$ as per Chiang (1984).
Warning: the code has only been tested for data based on single-year age groups.
}
\examples{
# Compute Victorian life table for females in 2003
aus_mortality |>
  dplyr::filter(Code == "VIC", Sex == "female", Year == 2003) |>
  life_table()
}
\references{
Chiang CL. (1984) \emph{The life table and its applications}. Robert E Krieger Publishing Company: Malabar.

Keyfitz, N, and Caswell, H. (2005) \emph{Applied mathematical demography}, Springer-Verlag: New York.

Preston, S.H., Heuveline, P., and Guillot, M. (2001) \emph{Demography: measuring and modeling population processes}. Blackwell
}
\author{
Rob J Hyndman
}
