% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_metrics_items_cor_items}
\alias{plot_metrics_items_cor_items}
\title{Heatmap for correlations between multiple items}
\usage{
plot_metrics_items_cor_items(
  data,
  cols,
  cross,
  method = "pearson",
  numbers = FALSE,
  title = TRUE,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{Tidyselect item variables (e.g. starts_with...).}

\item{cross}{Tidyselect item variables to correlate (e.g. starts_with...).}

\item{method}{The method of correlation calculation, pearson = Pearson's R, spearman = Spearman's rho.}

\item{numbers}{Controls whether to display correlation coefficients on the plot.}

\item{title}{If TRUE (default) shows a plot title derived from the column labels.
Disable the title with FALSE or provide a custom title as character value.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_metrics}.}
}
\value{
A ggplot object.
}
\description{
Heatmap for correlations between multiple items
}
\examples{
library(volker)
data <- volker::chatgpt

plot_metrics_items_cor_items(data, starts_with("cg_adoption_adv"), starts_with("use_"))

}
\keyword{internal}
