% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_stations_in.R
\name{find_stations_in}
\alias{find_stations_in}
\title{Find Stations Within a Geospatially Defined Geographic Area of Interest}
\usage{
find_stations_in(
  x,
  centroid = FALSE,
  api_key = NULL,
  which_api = "all",
  include_closed = FALSE,
  crs = "EPSG:7844"
)
}
\arguments{
\item{x}{One of two types of object:
\itemize{
\item A \code{Vector} A four-digit vector defining a bounding box of the area
of interest in this order, \sQuote{xmin}, \sQuote{ymin}, \sQuote{xmax},
\sQuote{ymax}, or
\item An object of class \CRANpkg{sf} defining the area of interest.
}}

\item{centroid}{\code{Boolean} A value of \code{TRUE} or \code{FALSE} indicating whether
you want the centroid only to be used to find the nearest station to the
centre of the area of interest.  If \dQuote{n} polygons are supplied,
\dQuote{n} stations are returned.  Defaults to \code{FALSE} with all stations
within the area of interest returned.}

\item{api_key}{A \code{character} string containing your \acronym{API} key from
\acronym{DPIRD}, \url{https://www.agric.wa.gov.au/web-apis}, for the
\acronym{DPIRD} Weather 2.0 \acronym{API}.  If left as \code{NULL}, defaults to
automatically detecting your key from your local .Renviron, .Rprofile or
similar.  Alternatively, you may directly provide your key as a string
here.  If nothing is provided, you will be prompted on how to set up your
\R session so that it is auto-detected.  Only used  when \var{which_api} is
\code{DPIRD} or \code{all}.}

\item{which_api}{A \code{string} value that indicates which \acronym{API} to use.
Defaults to \code{silo} only.  Valid values are \code{all}, for both \acronym{SILO}
(\acronym{BOM}) and \acronym{DPIRD} weather station networks; \code{silo} for
only stations in the \acronym{SILO} network; or \code{dpird} for stations in the
\acronym{DPIRD} network.}

\item{include_closed}{A \code{Boolean} value that indicates whether closed
stations in the \acronym{DPIRD} network should be included in the results.
Defaults to \code{FALSE} with closed stations not included.}

\item{crs}{A \code{string} value that provides the coordinate reference system,
AKA, "projection" to be used for the point extraction.  Defaults to
GDA 2020, EPSG:7844.  \strong{NOTE} This will override any \code{crs} value that your
.  \code{polygon} provides unless you specify it again here, \emph{e.g.},
\code{crs = sf::st_crs(polygon_object_name)}.}
}
\value{
a \CRANpkg{data.table} object of weather station(s) within the
defined area of interest in an unprojected format, EPSG:4326, WGS 84 --
WGS84 - World Geodetic System 1984, used in \acronym{GPS} format.
}
\description{
Given an \CRANpkg{sf} polygon or a bounding box as a vector with the minimum
and maximum longitude and latitude values, find \acronym{DPIRD} or
\acronym{BOM} stations in the \acronym{SILO} network that fall within that
defined area or the station nearest the centroid of the area of interest.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# using a (generous) bounding box for Melbourne, Vic using only the SILO API
# for BOM stations, so no API key is needed.

bbox <- find_stations_in(
  x = c(144.470215, -38.160476, 145.612793, -37.622934),
  which_api = "SILO",
  include_closed = TRUE
)
bbox

# Use the same bounding box but only find a single station nearest
# the centroid using only the SILO API for BOM stations

centroid <- find_stations_in(
  x = c(144.470215, -38.160476, 145.612793, -37.622934),
  which_api = "SILO",
  include_closed = TRUE,
  centroid = TRUE
)
centroid

# Use the `south_west_agricultural_region` data to fetch stations only in the
# south-western portion of WA and plot it with {ggplot2} showing open/closed
# stations just to be sure they're inside the area of interest.

# As this is in WA, we can use the DPIRD network, so we need our API key.
# Using the `south_west_agricultural_region` {sf} object provided.

sw_wa <- find_stations_in(
  x = south_west_agricultural_region,
  api_key = "your_api_key",
  include_closed = TRUE
)

sw_wa
\dontshow{\}) # examplesIf}
}
\seealso{
Other DPIRD: 
\code{\link{dpird_extreme_weather_values}},
\code{\link{dpird_minute_values}},
\code{\link{dpird_summary_values}},
\code{\link{find_nearby_stations}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_availability}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_stations_metadata}()}

Other SILO: 
\code{\link{find_nearby_stations}()},
\code{\link{get_data_drill}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_patched_point}()},
\code{\link{get_patched_point_apsim}()},
\code{\link{get_stations_metadata}()},
\code{\link{silo_daily_values}}

Other metadata: 
\code{\link{find_forecast_towns}()},
\code{\link{find_nearby_stations}()},
\code{\link{get_available_imagery}()},
\code{\link{get_available_radar}()},
\code{\link{get_dpird_availability}()},
\code{\link{get_stations_metadata}()}
}
\concept{DPIRD}
\concept{SILO}
\concept{metadata}
