% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_elevation_slice}
\alias{wbt_lidar_elevation_slice}
\title{Lidar elevation slice}
\usage{
wbt_lidar_elevation_slice(
  input,
  output,
  minz = NULL,
  maxz = NULL,
  cls = FALSE,
  inclassval = 2,
  outclassval = 1,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{output}{Output LiDAR file.}

\item{minz}{Minimum elevation value (optional).}

\item{maxz}{Maximum elevation value (optional).}

\item{cls}{Optional boolean flag indicating whether points outside the range should be retained in output but reclassified.}

\item{inclassval}{Optional parameter specifying the class value assigned to points within the slice.}

\item{outclassval}{Optional parameter specifying the class value assigned to points within the slice.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Outputs all of the points within a LiDAR (LAS) point file that lie between a specified elevation range.
}
\keyword{LiDARTools}
