% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewtpr.R
\name{EWTPR}
\alias{EWTPR}
\title{Expected win time against trial population With redistribution to the right}
\usage{
EWTPR(
  n,
  m,
  nunique2,
  maxfollow2,
  untimes2,
  Time,
  Delta,
  dist2,
  markov_ind,
  cov,
  trt,
  comkm,
  trans_prob2,
  nunique1,
  maxfollow1,
  untimes1,
  dist1,
  trtkm,
  trans_prob1,
  nunique0,
  maxfollow0,
  untimes0,
  dist0,
  conkm,
  trans_prob0,
  nimp
)
}
\arguments{
\item{n}{The total number of trial participants.}

\item{m}{The number of events in the hierarchy.}

\item{nunique2}{The number of unique combined arm event times (returned from wintime::markov() or wintime::km()).}

\item{maxfollow2}{The max combined arm follow up time (days) (returned from wintime::markov() or wintime::km()).}

\item{untimes2}{A vector containing unique combined arm event times (days) (returned from wintime::markov() or wintime::km()).}

\item{Time}{A m x n matrix of event times (days). Rows should represent events and columns should represent participants. Rows should be
in increasing order of clinical severity.}

\item{Delta}{A m x n matrix of event indicators Rows should represent events and columns should represent participants. Rows should be
in increasing order of clinical severity.}

\item{dist2}{A matrix of combined arm state probabilities (returned from wintime::markov() or wintime::km()).}

\item{markov_ind}{An indicator of the model type used (1 for Markov, 0 for Kaplan-Meier).}

\item{cov}{A n x p matrix of covariate values, where p is the number of covariates.}

\item{trt}{A vector of length n containing treatment arm indicators (1 for treatment, 0 for control).}

\item{comkm}{A m x nunique matrix of combined arm survival probabilities (returned from wintime::markov() or wintime::km()).}

\item{trans_prob2}{A (m x m x number of combined arm event times)
matrix where (i,j,k)'th value is transition probability from state i to state j at k'th combined arm event time. (returned from wintime::markov() or wintime::km()).}

\item{nunique1}{The number of unique trt arm event times (returned from wintime::markov() or wintime::km()).}

\item{maxfollow1}{The max trt arm follow up time (days) (returned from wintime::markov() or wintime::km()).}

\item{untimes1}{A vector containing unique trt arm event times (days) (returned from wintime::markov() or wintime::km()).}

\item{dist1}{A matrix of trt arm state probabilities (returned from wintime::markov() or wintime::km()).}

\item{trtkm}{A m x nunique matrix of trt arm survival probabilities (returned from wintime::markov() or wintime::km()).}

\item{trans_prob1}{A (m x m x number of trt arm event times)
matrix where (i,j,k)'th value is transition probability from state i to state j at k'th trt arm event time. (returned from wintime::markov() or wintime::km()).}

\item{nunique0}{The number of unique control arm event times (returned from wintime::markov() or wintime::km()).}

\item{maxfollow0}{The max control arm follow up time (days) (returned from wintime::markov() or wintime::km()).}

\item{untimes0}{A vector containing unique control arm event times (days) (returned from wintime::markov() or wintime::km()).}

\item{dist0}{A matrix of control arm state probabilities (returned from wintime::markov() or wintime::km()).}

\item{conkm}{A m x nunique matrix of control arm survival probabilities (returned from wintime::markov() or wintime::km()).}

\item{trans_prob0}{A (m x m x number of control arm event times)
matrix where (i,j,k)'th value is transition probability from state i to state j at k'th control arm event time. (returned from wintime::markov() or wintime::km()).}

\item{nimp}{The number of random imputations.}
}
\value{
A list containing: The estimated treatment effect from the linear regression model, the variance, the Z-statistic, the components of the treatment effect, and the variance of the components.
}
\description{
Calculates the combined arm state space probabilities using a Markov model or a Kaplan-Meier model (recommended).
This function uses these probabilities to compare each participant's clinical state to a distribution of combined arm states.
Calculation is extended by redistribution-to-the-right principles
}
