% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm.R
\name{rm_object_in_workspace}
\alias{rm_object_in_workspace}
\title{Remove an Object in a Workspace}
\usage{
rm_object_in_workspace(x, name, type, subdir = NULL)
}
\arguments{
\item{x}{the workspace}

\item{name}{name of the object stored in the workspace}

\item{type}{content type}

\item{subdir}{Optional subdirectory used for the asset to retrieve}
}
\value{
Returns the \link{workspace} object passed to \code{x} parameter. Called primarily for side effects.
}
\description{
Remove an object stored in a workspace.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_dataset(x = z, dataset = iris, name = "iris_dataset")
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
json_str <- paste0("{\"first_name\": \"John\",\"last_name\": \"Smith\",\"is_alive\": true,",
"\"age\": 27, \"address\": { \"street_address\": \"21 2nd Street\",",
"\"city\": \"New York\",\"state\": \"NY\",\"postal_code\": \"10021-3100\"",
"}}")
z <- store_json(
  x = z,
  json_str = json_str,
  filename = "example.json",
  timestamp = "2023-11-12 11:37:41",
  subdir = "blah"
)
z <- store_rds(
  x = z,
  obj = mtcars,
  filename = "obj.rds",
  timestamp = "2023-11-12 11:37:41",
  subdir = "r-object"
)
rm_object_in_workspace(
  x = z,
  name = "obj",
  type = "rds",
  subdir = "r-object"
)
}
\seealso{
\link{workspace} for package documentation
}
