% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fone.R
\name{fone_dataset}
\alias{fone_dataset}
\alias{fone_view}
\title{Return Finances One API Data}
\source{
\url{https://financesone.worldbank.org/data}
}
\usage{
fone_dataset(dataset_id, resource_id, ..., limit = NULL)

fone_view(view_id, ..., limit = NULL)
}
\arguments{
\item{dataset_id}{(\code{character(1)}) id of the associated dataset.}

\item{resource_id}{(\code{character(1)}) id of the associated resource.}

\item{...}{(\code{any}) additional arguments passed to the request.}

\item{limit}{(\code{integer(1)}) the maximum number of rows to return. Default is \code{NULL}.
If \code{NULL}, all rows are returned.}

\item{view_id}{(\code{character(1)}) id of the view.}
}
\value{
A \code{data.frame()} with the requested dataset.
}
\description{
Return Finances One API Data
}
\examples{
\dontrun{
fone_dataset(dataset_id = "DS00047", resource_id = "RS00005")
fone_view(view_id = "DS01538")
}
}
