% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{scale_xaringan}
\alias{scale_xaringan}
\alias{scale_xaringan_discrete}
\alias{scale_xaringan_fill_discrete}
\alias{scale_xaringan_color_discrete}
\alias{scale_xaringan_colour_discrete}
\alias{scale_xaringan_continuous}
\alias{scale_xaringan_fill_continuous}
\alias{scale_xaringan_color_continuous}
\alias{scale_xaringan_colour_continuous}
\title{Themed ggplot2 Scales}
\usage{
scale_xaringan_discrete(
  aes_type = c("color", "colour", "fill"),
  ...,
  color = NULL,
  direction = 1,
  inverse = FALSE
)

scale_xaringan_fill_discrete(..., color = NULL, direction = 1, inverse = FALSE)

scale_xaringan_color_discrete(
  ...,
  color = NULL,
  direction = 1,
  inverse = FALSE
)

scale_xaringan_colour_discrete(
  ...,
  color = NULL,
  direction = 1,
  inverse = FALSE
)

scale_xaringan_continuous(
  aes_type = c("color", "colour", "fill"),
  ...,
  color = NULL,
  begin = 0,
  end = 1,
  inverse = FALSE
)

scale_xaringan_fill_continuous(
  ...,
  color = NULL,
  begin = 0,
  end = 1,
  inverse = FALSE
)

scale_xaringan_color_continuous(
  ...,
  color = NULL,
  begin = 0,
  end = 1,
  inverse = FALSE
)

scale_xaringan_colour_continuous(
  ...,
  color = NULL,
  begin = 0,
  end = 1,
  inverse = FALSE
)
}
\arguments{
\item{aes_type}{The type of aesthetic to which the scale is being applied.
One of "color", "colour", or "fill".}

\item{...}{Arguments passed on to either the \pkg{colorspace} scale
functions — one of \code{\link[colorspace:scale_colour_discrete_sequential]{colorspace::scale_color_discrete_sequential()}},
\code{\link[colorspace:scale_colour_continuous_sequential]{colorspace::scale_color_continuous_sequential()}},
\code{\link[colorspace:scale_colour_discrete_sequential]{colorspace::scale_fill_discrete_sequential()}}, or
\code{\link[colorspace:scale_colour_continuous_sequential]{colorspace::scale_fill_continuous_sequential()}} — or to
\link[ggplot2:continuous_scale]{ggplot2::continuous_scale} or \link[ggplot2:discrete_scale]{ggplot2::discrete_scale}.}

\item{color}{A color value, in hex, to override the default color. Otherwise,
the primary color of the resulting scale is chosen from the xaringanthemer
slide styles.}

\item{direction}{Direction of the discrete scale. Use values less than 0 to
reverse the direction, e.g. \code{direction = -1}.}

\item{inverse}{If \code{color} is not supplied and \code{inverse = TRUE}, a primary
color is chosen to work well with the inverse slide styles, namely the
value of \code{inverse_header_color}}

\item{begin}{Number in the range of \code{[0, 1]} indicating to which point in the color scale the smallest data value should be mapped.}

\item{end}{Number in the range of \code{[0, 1]} indicating to which point in the color scale the largest data value should be mapped.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Color and fill single-color scales for discrete and continuous values,
created using the primary accent color of the xaringanthemer styles.  See
\code{vignette("ggplot2-themes")} for more information and examples of
\pkg{xaringanthemer}'s \pkg{ggplot2}-related functions.
}
\examples{
# Requires ggplot2
has_ggplot2 <- requireNamespace("ggplot2", quietly = TRUE)

if (has_ggplot2) {
  library(ggplot2)
  # Saving the theme to a temp file because this is an example
  path_to_css_file <- tempfile(fileext = ".css")

  # Create the xaringan theme: dark blue background with teal green accents
  style_duo(
    primary_color = "#002b36",
    secondary_color = "#31b09e",
    # Using basic fonts for this example, but the plot theme will
    # automatically use your theme font if you use Google fonts
    text_font_family = "sans",
    header_font_family = "serif",
    outfile = path_to_css_file
  )

  # Here's some very basic example data
  ex <- data.frame(
    name = c("Couple", "Few", "Lots", "Many"),
    n = c(2, 3, 5, 7)
  )

  # Fill color scales demo
  ggplot(ex) +
    aes(name, n, fill = n) +
    geom_col() +
    ggtitle("Matching fill scales") +
    # themed to match the slides: dark blue background with teal text
    theme_xaringan() +
    # Fill color matches teal text
    scale_xaringan_fill_continuous()

  # Color scales demo
  ggplot(ex) +
    aes(name, y = 1, color = name) +
    geom_point(size = 10) +
    ggtitle("Matching color scales") +
    # themed to match the slides: dark blue background with teal text
    theme_xaringan() +
    # Fill color matches teal text
    scale_xaringan_color_discrete(direction = -1)
}
}
