% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelines.R
\name{newCross2Pipeline}
\alias{newCross2Pipeline}
\title{Converts two genes into a genetic operator pipeline with crossover (2 kids).}
\usage{
newCross2Pipeline(g, g1, lF)
}
\arguments{
\item{g}{A gene.}

\item{g1}{A gene.}

\item{lF}{The local function configuration.}
}
\value{
Closure of genetic operator pipeline 
        with crossover only.
        The argument of the closure \code{lF} 
        configures the behavior of the pipeline.
}
\description{
The pipeline is \code{evaluate(accept(crossover, gene, gene1))}.
             The execution of this pipeline produces two genes.
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCross2Gene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OpPipeline, gene, lF) {OpPipeline(gene, lF)}
g<-xegaGaInitGene(lFxegaGaGene)
g1<-xegaGaInitGene(lFxegaGaGene)
a<-newCross2Pipeline(g, g1, lFxegaGaGene)
print(a)
a(lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines: 
\code{\link{newCross2Mut1Pipeline}()},
\code{\link{newCross2Mut2Pipeline}()},
\code{\link{newCrossMut2Pipeline}()},
\code{\link{newCrossMutPipeline}()},
\code{\link{newCrossPipeline}()},
\code{\link{newMutPipeline}()},
\code{\link{newPipeline}()}
}
\concept{Genetic Operator Pipelines}
