

/*
Adapted from https://github.com/Rahix/avr-device.

See also src/imp/avr.rs.

Refs:
- AVR® Instruction Set Manual, Rev. DS40002198B
  https://ww1.microchip.com/downloads/en/DeviceDoc/AVR-InstructionSet-Manual-DS40002198.pdf

Generated asm:
- avr https://godbolt.org/z/W5jxGsToc
*/

#[cfg(not(portable_atomic_no_asm))]
use core::arch::asm;

#[cfg(not(portable_atomic_no_asm))]
pub(super) use super::super::avr as atomic;

pub(super) type State = u8;


#[inline(always)]
pub(super) fn disable() -> State {
    let sreg: State;


    unsafe {



        #[cfg(not(portable_atomic_no_asm))]
        asm!(
            "in {sreg}, 0x3F", // sreg = SREG
            "cli",             // SREG.I = 0
            sreg = out(reg) sreg,
            options(nostack),
        );
        #[cfg(portable_atomic_no_asm)]
        {
            llvm_asm!("in $0, 0x3F" : "=r"(sreg) ::: "volatile");
            llvm_asm!("cli" ::: "memory" : "volatile");
        }
    }
    sreg
}






#[inline(always)]
pub(super) unsafe fn restore(prev_sreg: State) {

    unsafe {




        #[cfg(not(portable_atomic_no_asm))]
        asm!(
            "out 0x3F, {prev_sreg}", // SREG = prev_sreg
            prev_sreg = in(reg) prev_sreg,
            options(nostack),
        );
        #[cfg(portable_atomic_no_asm)]
        llvm_asm!("out 0x3F, $0" :: "r"(prev_sreg) : "memory" : "volatile");
    }
}
