% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_cases.R
\name{count_cases}
\alias{count_cases}
\title{Convert data on the report level to aggregated data.}
\usage{
count_cases(
  data,
  drug.case = drug.case,
  drug.control = NULL,
  covar_disc = NULL,
  covar_cont = NULL,
  breaks = NULL,
  cores = detectCores(),
  min_AE = 10
)
}
\arguments{
\item{data}{a data.frame with at least 3 columns, consisting data on the report
level, having ID, Drug type and AE name as the first 3 columns with
covariates(optional) followed. The order of columns is not interchangeable.}

\item{drug.case}{a character string for the target drug of interest.}

\item{drug.control}{a character string for the reference drug. If NULL(default),
all other drugs combined are the reference.}

\item{covar_disc}{a character vector of categorical covariates.}

\item{covar_cont}{a character vector of continuous covariates.}

\item{breaks}{a list consists of vectors used for creating specific bins to
transform continuous covariates into categorical. Breaks Should have the same
length as covar_cont. Given a vector of non-decreasing breakpoints in \code{breaks[i]},
find the interval containing each element of \code{covar_cont[i]}; i.e., for each index
j in \code{breaks[i]}, value j is assigned to \code{covar_cont[i]} if and only if \code{breaks[i][j]}
\verb{<= covar_cont[i] < breaks[i][j+1]}.}

\item{cores}{the number of cores to use for parallel execution.}

\item{min_AE}{the minimum number of cases required to start counting
for a specific AE. Default 10.}
}
\value{
A \strong{data.frame} consists of aggregated data.

The returned data.frame contains the following columns:
\describe{
\item{DRUG_TYPE: }{type of the drug, DrugYes for target drug and DrugNo for referenced drug}
\item{AE_NAME: }{the name of the adverse event}
\item{AEyes: }{number of observations that have this AE}
\item{AEno: }{number of observations that do not have this AE}
\item{covariates: }{covariates specifed by user}
}
}
\description{
The count_cases function is used to convert data on the report
level to aggregated data, grouping by specified covariates.
}
\examples{

# count_cases(data = covid1, drug.case = "COVID19", drug.control = "OTHER",
#             covar_cont = c("AGE"), covar_disc = c("SEX"),
#             breaks = list(c(16,30,50,65,120)))
            
}
