#' @title build file with judgment matrices
#' @name xlsx_ahp
#' @author Luciane Ferreira Alcoforado
#'
#' @description Function to build file with judgment matrices
#'
#' @param m is a matrix of pairwise comparison
#' @param file is the path to the output file.
#' @param sheet is a character string with the sheet name.
#' @param append is a logical value indicating if m should be appended to an existing file. 
#' @return Returns a xlsx document
#'
#' @examples
#' # Criando um arquivo temporário para o exemplo funcionar sem erro
#' library(openxlsx)
#' m1 <- matrix(c(1, 2, 0.5, 1), nrow = 2)
#' tmp <- tempfile(fileext = ".xlsx")
#' write.xlsx(list(Sheet1 = m1), file = tmp)
#' 
#' # Agora testando a função ler com o arquivo que acabamos de criar
#' lista = ler(tmp)
#' lista
#' 
#' @importFrom openxlsx write.xlsx
#' @export

xlsx_ahp = function(m, file, sheet, append = FALSE) {
  # O openxlsx gerencia o append de forma interna e eficiente
  openxlsx::write.xlsx(x = m, 
                       file = file, 
                       sheetName = sheet, 
                       append = append)
}
