% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotVoxelSpace.R
\name{plot}
\alias{plot}
\alias{plot,VoxelSpace,missing-method}
\alias{plot,VoxelSpace,data.table-method}
\title{Plot an object of class VoxelSpace}
\usage{
plot(x, y, ...)

\S4method{plot}{VoxelSpace,missing}(
  x,
  y,
  variable.name = "nbSampling",
  palette = "viridis",
  bg.color = "lightgrey",
  width = 640,
  voxel.size = 5,
  unsampled.discard = TRUE,
  empty.discard = TRUE,
  axis = "xyz",
  ...
)

\S4method{plot}{VoxelSpace,data.table}(
  x,
  y,
  variable.name = "nbSampling",
  palette = "viridis",
  bg.color = "lightgrey",
  width = 640,
  voxel.size = 5,
  unsampled.discard = TRUE,
  empty.discard = TRUE,
  axis = "xyz",
  ...
)
}
\arguments{
\item{x}{the object of class VoxelSpace to plot}

\item{y}{a subset of voxel index. A data.table with \verb{i, j, k} columns.
Missing parameter means whole voxel space.}

\item{...}{additional parameters which will be passed to \code{\link[rgl:plot3d]{rgl::plot3d()}}.}

\item{variable.name}{character, the name of the variable to plot}

\item{palette}{character, a valid palette name (one of hcl.pals())}

\item{bg.color}{character, a valid background color name (one of colors())}

\item{width}{numeric, the width of the windows}

\item{voxel.size}{numeric, the size of voxel in pixels}

\item{unsampled.discard}{logical, whether to discard unsampled voxel}

\item{empty.discard}{logical, whether to discard empty voxel (no hit)}

\item{axis}{character, one of \verb{c('ijk', xyz')}, ijk the voxel index or xyz the voxel coordinates}
}
\description{
plot a \code{\linkS4class{VoxelSpace}} object.
}
\details{
Plot an object of class VoxelSpace in a 3d device. By default it plots the
sampling intensity but the user can choose any variable available in the
voxel file.
}
\examples{
\dontrun{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# plot sampling intensity by default
plot(vxsp)
# plot PAD
plot(vxsp, variable.name = "PadBVTotal", palette = "YlOrRd")
# plot a subset
plot(vxsp, vxsp@data[k > 4, .(i, j, k)])
}
}
\seealso{
\code{\link[rgl:plot3d]{rgl::plot3d()}}
}
