% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{Carmel_Valley}
\alias{Carmel_Valley}
\title{Carmel Valley example dataset}
\format{
A \emph{mts_monitor} object with 576 rows and 2 columns of data.
}
\usage{
Carmel_Valley
}
\description{
The \code{Carmel_Valley} dataset provides a quickly loadable
version of a \emph{mts_monitor} object for practicing and code examples.
}
\details{
In August of 2016, the Soberanes fire in California burned along the Big Sur
coast. At the time, it was the most expensive wildfire in US history. This
dataset contains PM2.5 monitoring data for the monitor in Carmel Valley which
shows heavy smoke as well as strong diurnal cycles associated with sea
breezes. Data are stored as a \emph{mts_monitor} object and are used in some
examples in the package documentation.

This dataset was generated on 2022-10-12 by running:

\preformatted{
library(AirMonitor)

Carmel_Valley <-
  airnow_loadAnnual(2016) \%>\%
  monitor_filterMeta(deviceDeploymentID == "a9572a904a4ed46d_840060530002") \%>\%
  monitor_filterDate(20160722, 20160815)

save(Carmel_Valley, file = "data/Carmel_Valley.rda")
}
}
\keyword{datasets}
