% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_12_table_21}
\alias{chapter_12_table_21}
\alias{C12T21}
\alias{Chapter_12_Table_21}
\alias{c12t21}
\title{The data used in Chapter 12, Table 21}
\format{An object of class \code{data.frame} with 18 rows and 5 columns.}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (forthcoming). \emph{Designing experiments and 
analyzing data: {A} model comparison perspective}. (3rd ed.). Routledge.
}
\usage{
data(chapter_12_table_21)
}
\description{
The data used in Chapter 12, Table 21
}
\details{
Suppose that we are interested in comparing the effects of three drugs (A, B, and C) on aggressiveness on monkeys. To control for possible order effects, we use a Latin square design. Specifically, we suppose that six subjects are available (as we discussed in Chapter 11, a subject is actually a pair of monkeys in this design). Following the design principles outlined at the end of Chapter 11, we use a replicated Latin square design with two randomly consituted squares. Subjects are then randomly assigned to rows of the squares. The dependent measure can be thought of as the number of aggressive behvaiors engaged in during a fixed time period. Notice that each sore is a function of three possible influences: subject, time period, and treatment condition (where here is drug, with three levels, either A, B, or C).

To summarize, the data in Table 12.21 consists of hypothetical aggressiveness scores for 6 monkeys who have been exposed to three types of drugs (A, B, and C). In order to control for potential order effects, a Latin square design is utilized. In particular, two randomly constituted squares are formed with three monkeys randomly assigned to each square and also randomly assigned to the particular row of the square that assigns the order that they are exposed to treatment.
}
\section{Variables}{

\describe{
\item{dv}{dependent variable; the number of aggressive behaviors in a time period}
\item{subject}{one pair of monkeys (6 total)}
\item{time}{time period}
\item{cond}{treatment condition}
\item{square}{a numeric vector}
}
}

\section{Synonym}{

C12T21
}

\examples{
# Load the data
data(chapter_12_table_21)

# Or, alternatively load the data as
data(C12T21)

# View the structure
str(chapter_12_table_21)

}
\references{
Maxwell, S. E., Delaney, H. D., \& Kelley, K. (forthcoming). \emph{Designing experiments and analyzing data: 
{A} model comparison perspective} (3rd ed.). Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
