% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NMAX3_main.R
\name{nmax3}
\alias{nmax3}
\title{The NMAX3 based on the nonparametric trend test in a
quantitative trait association study}
\usage{
nmax3(y, g)
}
\arguments{
\item{y}{a numeric vector of the observed quantitative trait
values in which the \emph{i}th element is the trait value of the
\emph{i}th subject.}

\item{g}{a numeric vector of the observed genotype values (0, 1,
or 2 denotes the number of risk alleles) in which the \emph{i}th
element is the genotype value of the \emph{i}th subject for a
biallelic SNP. \code{g} has the same length as \code{y}.}
}
\value{
A list of \code{test.stat} and
\code{p.val}. \code{test.stat} is the observed value of the test
statistic and \code{p.val} is the p-value of the test.
}
\description{
Test for the association between a biallelic SNP and a
quantitative trait using the maximum value of the three
nonparametric trend tests derived for the recessive, additive, and
dominant models. It is a robust procedure against the genetic
models.
}
\details{
Under the null hypothesis of no association, the vector of the
three nonparametric tests under the recessive, additive, and
dominant models asymptotically follows a three-dimensional normal
distribution. The p-value can be calculated using the function
\link{pmvnorm} in the R package "mvtnorm".

This test is different from the MAX3 test using in the function
\link{max3}. On one hand, the NMAX3 applies to the quantitative
traits association studies. However, the MAX3 is used in the
case-control association studies. On the other hand, the NMAX3 is
based on the nonparametric trend test. However, the MAX3 is based
on the Cochran-Armitage trend test.
}
\examples{
g <- rbinom(1500, 2, 0.3)
y <- 0.5 + 0.25 * g + rgev(1500, 0, 0, 5)
nmax3(y, g)
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}
\references{
W Zhang and Q Li. Nonparametric risk and nonparametric
odds in quantitative genetic association studies. \emph{Science
Reports (2nd revision)}. 2015.

B Freidlin, G Zheng, Z Li, and JL Gastwirth. Trend
tests for case-control studies of genetic markers: power, sample
size and robustness. \emph{Human Heredity}. 2002; 53:146-152.

WG Cochran. Some methods for strengthening the common
chi-square tests. \emph{Biometrics}. 1954; 10:417-451.

P Armitage. Tests for linear trends in proportions and
frequencies. \emph{Biometrics}. 1955; 11:375-386.
}

