% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_functions.R
\name{mvnorm_chol}
\alias{mvnorm_chol}
\title{Draw a sample from a multivariate normal distribution}
\usage{
mvnorm_chol(mu, chol)
}
\arguments{
\item{mu}{The mean vector}

\item{chol}{The cholesky decomposition of the covariance matrix Sigma}
}
\value{
a vector containing a sample from the distribution
}
\description{
This draws a sample from a multivariate normal distribution with mean vector mu and covariance matrix Sigma. It requires the covariance matrix to be decomposed using the Cholesky method (chol).
}
\examples{

mu <- c(2, 1) #mean vector
sigma <- matrix(c(2^2, 0.5*2*1, 0.5*2*1, 1^2), 2, 2) #covariacne matrix
sigma.chol <- chol(sigma) #decompose covariance matrix
#f <- mvnorm_chol(mu, sigma.chol) #draw sample

}
\keyword{distribution}
\keyword{internal}
