% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_Moran.I}
\alias{plot_Moran.I}
\title{plot_Moran.I}
\usage{
plot_Moran.I(
  data,
  var_duration = character(),
  var_id = character(),
  var_time = character(),
  n = 1,
  t = 1.645
)
}
\arguments{
\item{data}{data.}

\item{var_duration}{variable that measures duration until censoring or failure.}

\item{var_id}{ID's unique identifier.}

\item{var_time}{variable that measures time.}

\item{n}{number of observation per id.}

\item{t}{value of the confidence interval.}
}
\value{
A ggplot object
}
\description{
Implements Global Moran I test to evaluate spatial autocorrelation in a units' risk propensity in the data.  Positive values indicate spatial clustering of similar values.
}
\examples{

library(BayesSPsurv)
dataw <- spduration::add_duration(data = BayesSPsurv::Walter_2015_JCR,
                                  y = "renewed_war",
                                  unitID = "ccode",
                                  tID = "year",
                                  freq = "year",
                                  ongoing = FALSE)


plot_Moran.I(data = dataw ,
            var_duration = "duration",
            var_id = "ccode",
            var_time = "year",
            n = 12)


}
