/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.operators;

import cern.jet.random.Beta;
import dr.evomodel.antigenic.phyloclustering.TreeClusteringVirusesPrior;
import dr.evomodel.antigenic.phyloclustering.operators.ProbSitesGibbsOperator;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ProbGenericSiteGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String CLASSNAME_OPERATOR = "probGenericSiteGibbsOperator";
    private TreeClusteringVirusesPrior clusterPrior;
    private Parameter probSites;
    private int numSites;
    private double probSite_alpha = 1.0;
    private double probSite_beta = 1.0;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String PROBSITES = "probSites";
        public static final String PROBSITE_ALPHA = "shape";
        public static final String PROBSITE_BETA = "shapeB";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(TreeClusteringVirusesPrior.class), new ElementRule("probSites", Parameter.class), AttributeRule.newDoubleRule("shape", true, "the alpha parameter in the Beta prior"), AttributeRule.newDoubleRule("shapeB", true, "the beta parameter in the Beta prior")};

        @Override
        public String getParserName() {
            return ProbGenericSiteGibbsOperator.CLASSNAME_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            XMLObject xMLObject2 = xMLObject.getChild(PROBSITES);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            TreeClusteringVirusesPrior treeClusteringVirusesPrior = (TreeClusteringVirusesPrior)xMLObject.getChild(TreeClusteringVirusesPrior.class);
            double d2 = 1.0;
            if (xMLObject.hasAttribute(PROBSITE_ALPHA)) {
                d2 = xMLObject.getDoubleAttribute(PROBSITE_ALPHA);
            }
            double d3 = 1.0;
            if (xMLObject.hasAttribute(PROBSITE_BETA)) {
                d3 = xMLObject.getDoubleAttribute(PROBSITE_BETA);
            }
            return new ProbGenericSiteGibbsOperator(d, treeClusteringVirusesPrior, parameter, d2, d3);
        }

        @Override
        public String getParserDescription() {
            return "An operator that updates the probability of sites given a beta distribution.";
        }

        @Override
        public Class getReturnType() {
            return ProbSitesGibbsOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ProbGenericSiteGibbsOperator(double d, TreeClusteringVirusesPrior treeClusteringVirusesPrior, Parameter parameter, double d2, double d3) {
        this.clusterPrior = treeClusteringVirusesPrior;
        this.probSites = parameter;
        this.numSites = this.clusterPrior.getNumSites();
        this.setWeight(d);
        this.probSite_alpha = d2;
        this.probSite_beta = d3;
    }

    @Override
    public double doOperation() {
        int[] nArray = this.clusterPrior.getCausalCount();
        int[] nArray2 = this.clusterPrior.getNonCausalCount();
        int n = this.clusterPrior.getNumSites();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
            d2 += (double)nArray2[i];
        }
        double d3 = Beta.staticNextDouble(d + this.probSite_alpha, d2 + this.probSite_beta);
        this.probSites.setParameterValue(0, d3);
        return 0.0;
    }

    @Override
    public void accept(double d) {
        super.accept(d);
    }

    @Override
    public void reject() {
        super.reject();
    }

    @Override
    public final String getOperatorName() {
        return CLASSNAME_OPERATOR;
    }

    public int getStepCount() {
        return 1;
    }
}

