/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EpochBranchModel
extends AbstractModel
implements BranchModel,
Citable {
    public static final String EPOCH_BRANCH_MODEL = "EpochBranchModel";
    private final TreeModel tree;
    private final List<SubstitutionModel> substitutionModels;
    private final Parameter epochTimes;

    public EpochBranchModel(TreeModel treeModel, List<SubstitutionModel> list, Parameter parameter) {
        super(EPOCH_BRANCH_MODEL);
        this.substitutionModels = list;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("EpochBranchModel must be provided with at least one substitution model");
        }
        this.epochTimes = parameter;
        this.tree = treeModel;
        for (SubstitutionModel substitutionModel : list) {
            this.addModel(substitutionModel);
        }
        this.addModel(treeModel);
        this.addVariable(parameter);
    }

    @Override
    public BranchModel.Mapping getBranchModelMapping(NodeRef nodeRef) {
        int n;
        int n2 = this.substitutionModels.size();
        int n3 = n2 - 1;
        double[] dArray = this.epochTimes.getParameterValues();
        double d = this.tree.getNodeHeight(this.tree.getParent(nodeRef));
        double d2 = this.tree.getNodeHeight(nodeRef);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < n3 && d2 >= dArray[n]; ++n) {
        }
        double d3 = d2;
        while (n < n3 && d >= dArray[n]) {
            arrayList.add(dArray[n] - d3);
            arrayList2.add(n);
            d3 = dArray[n];
            ++n;
        }
        arrayList.add(d - d3);
        arrayList2.add(n);
        if (arrayList2.size() == 0) {
            throw new RuntimeException("EpochBranchModel failed to give a valid mapping");
        }
        final int[] nArray = new int[arrayList2.size()];
        final double[] dArray2 = new double[arrayList.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            nArray[i] = (Integer)arrayList2.get(i);
            dArray2[i] = (Double)arrayList.get(i);
        }
        return new BranchModel.Mapping(){

            @Override
            public int[] getOrder() {
                return nArray;
            }

            @Override
            public double[] getWeights() {
                return dArray2;
            }
        };
    }

    @Override
    public boolean requiresMatrixConvolution() {
        return true;
    }

    @Override
    public List<SubstitutionModel> getSubstitutionModels() {
        return this.substitutionModels;
    }

    @Override
    public SubstitutionModel getRootSubstitutionModel() {
        return this.substitutionModels.get(this.substitutionModels.size() - 1);
    }

    @Override
    public FrequencyModel getRootFrequencyModel() {
        return this.getRootSubstitutionModel().getFrequencyModel();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Epoch Branch model";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("F", "Bielejec"), new Author("P", "Lemey"), new Author("G", "Baele"), new Author("A", "Rambaut"), new Author("MA", "Suchard")}, Citation.Status.IN_PREPARATION));
    }
}

