/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SiteList;
import dr.evolution.alignment.SitePatterns;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class MaskedPatternsParser
extends AbstractXMLObjectParser {
    public static final String MASKED_PATTERNS = "maskedPatterns";
    public static final String MASK = "mask";
    public static final String NEGATIVE = "negative";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("negative", true), new ElementRule(SiteList.class), new ElementRule("mask", String.class, "A parameter of 1s and 0s that represent included and excluded sites")};

    @Override
    public String getParserName() {
        return MASKED_PATTERNS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        SiteList siteList = (SiteList)xMLObject.getChild(SiteList.class);
        boolean bl = xMLObject.getBooleanAttribute(NEGATIVE);
        String string = (String)xMLObject.getElementFirstChild(MASK);
        boolean[] blArray = new boolean[siteList.getSiteCount()];
        int n = 0;
        for (char c : string.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            if (n >= blArray.length) break;
            blArray[n] = c == '0' ? bl : !bl;
            ++n;
        }
        if (n != blArray.length) {
            throw new XMLParseException("The mask needs to be the same length as the alignment (spaces are ignored)");
        }
        Object object = new SitePatterns(siteList, blArray, false, false);
        if (object == null) {
            throw new XMLParseException("The mask needs include at least one pattern");
        }
        if (xMLObject.hasAttribute("id")) {
            Logger logger = Logger.getLogger("dr.evoxml");
            logger.info("Site patterns '" + xMLObject.getId() + "' created by masking alignment with id '" + siteList.getId() + "'");
            logger.info("  pattern count = " + ((SitePatterns)object).getPatternCount());
        }
        return object;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "A weighted list of the unique site patterns (unique columns) in an alignment.";
    }

    @Override
    public Class getReturnType() {
        return PatternList.class;
    }
}

