/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import java.util.List;

public class SumParameter
extends Parameter.Abstract
implements VariableListener {
    private final List<Parameter> parameterList;
    private final int dimension;
    private Bounds bounds = null;

    public SumParameter(List<Parameter> list) {
        this.parameterList = list;
        this.dimension = list.size() == 1 ? 1 : list.get(0).getDimension();
        for (Parameter parameter : list) {
            parameter.addVariableListener(this);
        }
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    protected void storeValues() {
        for (Parameter parameter : this.parameterList) {
            parameter.storeParameterValues();
        }
    }

    @Override
    protected void restoreValues() {
        for (Parameter parameter : this.parameterList) {
            parameter.restoreParameterValues();
        }
    }

    @Override
    protected void acceptValues() {
        for (Parameter parameter : this.parameterList) {
            parameter.acceptParameterValues();
        }
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getParameterValue(int n) {
        double d = 0.0;
        if (this.dimension == 1) {
            d = this.parameterList.get(0).getParameterValue(0);
            for (int i = 1; i < this.parameterList.get(0).getDimension(); ++i) {
                d += this.parameterList.get(0).getParameterValue(i);
            }
        } else {
            d = this.parameterList.get(0).getParameterValue(n);
            for (int i = 1; i < this.parameterList.size(); ++i) {
                d += this.parameterList.get(i).getParameterValue(n);
            }
        }
        return d;
    }

    @Override
    public void setParameterValue(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String getParameterName() {
        if (this.getId() == null) {
            StringBuilder stringBuilder = new StringBuilder("sum");
            for (Parameter parameter : this.parameterList) {
                stringBuilder.append(".").append(parameter.getId());
            }
            this.setId(stringBuilder.toString());
        }
        return this.getId();
    }

    @Override
    public void addBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    @Override
    public Bounds<Double> getBounds() {
        if (this.bounds == null) {
            return this.parameterList.get(0).getBounds();
        }
        return this.bounds;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireParameterChangedEvent(n, changeType);
    }
}

