% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMM.R
\name{ARMM}
\alias{ARMM}
\title{Adaptive Randomization via Mahalanobis distance for Multi-arm design}
\usage{
ARMM(covariate, assignment, K, q = 0.75, method)
}
\arguments{
\item{covariate}{a data frame. A row of the dataframe
corresponds to the covariate profile of a patient.}

\item{assignment}{a vector. If partial patients had been allocated
, please input their allocation. IF
all the patients are not be allocated, please input
'assignment = NA' directly.}

\item{K}{an integer; number of arms of the trial.}

\item{q}{the biased coin probability.
\eqn{q} should be larger than 1/2 and less than 1, default = 0.75}

\item{method}{Methods for calculating Mahalanobis distance, input one of these texts:
'mean', 'max' or 'median'.}
}
\value{
An object of class "ARMM" is a list containing the following components:
\item{assignment}{Allocation of patients.}
\item{sample_size}{The number of patients from treatment 1 to treatment \eqn{K} respectively.}
\item{Mahalanobis_Distance}{Mahalanobis distance among treatment groups .}
}
\description{
Randomize patients into treatment groups
for multi-arm trials using ARMM proposed by Haoyu Yang, Yichen Qin,
Yang Li, Fan Wang, and Feifang Hu.(2022)
}
\details{
Suppose \eqn{n} units (participants) are to be assigned to \eqn{K}
treatment groups. For each unit \eqn{i, i = 1, ..., n} and
treatment \eqn{j, j = 1, ..., K}, define the assignment
matrix \eqn{[T_{ij}]^{n*K}}, where
\eqn{T_{ij}=1} indicates unit \eqn{i} receives treatment \eqn{j}.
Consider \eqn{p} continuous covariates, let \eqn{x_i =
(x_{i1},...,x_{in})^T}.

The proposed method, namely the adaptive randomization
via Mahalanobis distance for multi-arm design (ARMM),
is outlined below. The implement of ARMM is similar to ARM.

First assume that \eqn{n} units are in a sequence
and then assign the first \eqn{K} units to \eqn{K} treatment
groups randomly
as the initialization. Then,
the following units are assigned in blocks of \eqn{K}
sequentially and
adaptively until all the units
are assigned. For \eqn{K} units are assigned to \eqn{K}
groups, there are in total \eqn{K!} possible allocations.
Calculate \eqn{K!} potential overall
covariate imbalance measurement
according to pairwise Mahalanobis
distance under the \eqn{K!} possible allocations.
Choose the allocation which corresponds to the smallest
Mahalanobis
distance with a probability of \eqn{q} across all potential allocations.
Repeat the process until all units are assigned.

For any pair of treatments \eqn{s} and \eqn{t} among the \eqn{K}
treatment groups, calculate the Mahalanobis distance by:

{\deqn{M_{s,t}(n) = 2n/K/K(\hat{x}_1 -\hat{x}_2)^Tcov(x)^{-1}(\hat{x}_1 -\hat{x}_2)}}

In total, there are \eqn{C_K^2} pairs of Mahalanobis
distances among \eqn{K} treatment groups.Finally, calculate
the mean, the median or the maximum to represent the total imbalance.

See the reference for more details.
}
\examples{
library(MASS)
#simulate covariates of patients
p <- 6; n <- 30
sigma <- diag(p); mean <- c(rep(0,p))
data <- mvrnorm(n, mean, sigma)
covariate <- as.data.frame(data)
#IF all the patients are not be allocated
ARMM(covariate = covariate, assignment = NA, K = 3, q = 0.75, method = 'mean')
#IF you had allocated partial patients
ARMM(covariate = covariate, assignment = c(1,2), K=4, q=0.75, method = 'max')
}
\references{
Yang H, Qin Y, Wang F, et al. Balancing covariates in multi-arm trials via adaptive randomization. Computational Statistics & Data Analysis, 2023, 179: 107642. https://doi.org/10.1016/j.csda.2022.107642
}
