% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_arm_attrition_designer.R
\name{two_arm_attrition_designer}
\alias{two_arm_attrition_designer}
\title{Create design with risk of attrition or post treatment conditioning}
\usage{
two_arm_attrition_designer(
  N = 100,
  a_R = 0,
  b_R = 1,
  a_Y = 0,
  b_Y = 1,
  rho = 0,
  args_to_fix = NULL
)
}
\arguments{
\item{N}{An integer. Size of sample.}

\item{a_R}{A number. Constant in equation relating treatment to responses.}

\item{b_R}{A number. Slope coefficient in equation relating treatment to responses.}

\item{a_Y}{A number. Constant in equation relating treatment to outcome.}

\item{b_Y}{A number. Slope coefficient in equation relating treatment to outcome.}

\item{rho}{A number in [0,1]. Correlation between shocks in equations for R and Y.}

\item{args_to_fix}{A character vector. Names of arguments to be args_to_fix in design.}
}
\value{
A post-treatment design.
}
\description{
Creates a two-arm design with application for when estimand of interest is conditional on a post-treatment outcome 
(the effect on Y given R) or data is conditionally observed (Y given R). See `Details` for more information on the data generating process.
}
\details{
The data generating process is of the form: 

    \code{R ~ (a_R + b_R*Z > u_R)}
    
    \code{Y ~ (a_Y + b_Y*Z > u_Y)}
    
    where \code{u_R} and \code{u_Y} are joint normally distributed with correlation \code{rho}.
}
\examples{
# To make a design using default argument (missing completely at random):
two_arm_attrition_design <- two_arm_attrition_designer()
\dontrun{
diagnose_design(two_arm_attrition_design)
}
# Attrition can produce bias even for unconditional ATE even when not
# associated with treatment
\dontrun{
diagnose_design(two_arm_attrition_designer(b_R = 0, rho = .3))
}
# Here the linear estimate using R=1 data is unbiased for
# "ATE on Y (Given R)" with b_R = 0 but not when  b_R = 1   
\dontrun{
diagnose_design(redesign(two_arm_attrition_design, b_R = 0:1, rho = .2))
}
}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{post-treatment}
