% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSCoTEA.R
\name{DiSCoTEA}
\alias{DiSCoTEA}
\title{Aggregate treatment effects from DiSCo function.}
\usage{
DiSCoTEA(
  disco,
  agg = "quantileDiff",
  graph = TRUE,
  t_plot = NULL,
  savePlots = FALSE,
  xlim = NULL,
  ylim = NULL,
  samples = c(0.25, 0.5, 0.75)
)
}
\arguments{
\item{disco}{Output of the DiSCo function.}

\item{agg}{String indicating the aggregation statistic to be used. Options include
\itemize{
\item \code{quantileDiff}  Difference in quantiles between the target and the weighted average of the controls.
\item \code{quantile} Plots both the observed and the counterfactual quantile functions. No summary statistics will be produced.
\item \code{cdfDiff}  Difference in CDFs between the target and the weighted average of the controls.
\item \code{cdf} Plots both the observed and the counterfactual CDFs. No summary statistics will be produced.
}}

\item{graph}{Boolean indicating whether to plot graphs (default is TRUE).}

\item{t_plot}{Optional vector of time periods (\code{t_col} values in the original dataframe) to be plotted (default is NULL, which plots all time periods).}

\item{savePlots}{Boolean indicating whether to save the plots to the current working directory (default is FALSE). The plot names will be \verb{[agg]_[start_year]_[end_year].pdf}.}

\item{xlim}{Optional vector of length 2 indicating the x-axis limits of the plot. Useful for zooming in on relevant parts of the distribution for fat-tailed distributions.}

\item{ylim}{Optional vector of length 2 indicating the y-axis limits of the plot.}

\item{samples}{Numeric vector indicating the range of quantiles of the aggregation statistic (\code{agg}) to be summarized in the \code{summary} property of the S3 class returned by the function (default is c(0.25, 0.5, 0.75)).
For example, if \code{samples} = c(0.25, 0.5, 0.75), the summary table will include the average effect for the 0-25th, 25-50th, 50-75th and 75-100th quantiles of the distribution of the aggregation statistic over time.}
}
\value{
A \code{\link[DiSCos]{DiSCoT}} object, which is an S3 class that stores a list of treatment effects, their standard errors,
the corresponding confidence intervals (if specified), and a dataframe with treatment effects aggregated
according to the \code{agg} input. The S3 class also has a \code{summary} property that will print a selection of aggregated effects (specified by the \code{samples} parameter)
for the chosen \code{agg} method, by post-treatment year, as well as the permutation test results, if specified.
}
\description{
Function to aggregate treatment effects from the output of the
DiSCo function, plot the distribution of the aggregation statistic over time,
and report summary tables.
}
\details{
This function takes in the output of the DiSCo_per function and computes aggregate treatment effect using a user-specified aggregation statistic.
The default is the differences between the counterfactual and the observed quantile functions (\code{quantileDiff}). If \code{graph} is set to TRUE,
the function will plot the distribution of the aggregation statistic over time. The S3 class returned by the function
has a \code{summary} property that will print a selection of aggregated effects (specified by the \code{samples} parameter) for the chosen \code{agg} method, by post-treatment year (see examples below).
This \code{summary} call will only print effects if the \code{agg} parameter requested a distribution difference (\code{quantileDiff} or \code{cdfDiff}). The other aggregations are meant to be inspected visually.
If the \code{permutation} parameter was set to TRUE in the original \code{DiSCo} call, the summary table will include the results of the permutation test.
If the original \code{DiSCo} call was restricted to a range of quantiles smaller than \verb{[0,1]} (i.e. \code{q_min} > 0 or \code{q_max} < 1), the \code{samples} parameter is ignored
and only the aggregated differences for the quantile range specified in the original call are returned.
}
