\name{modifyHeader}
\alias{modifyHeader}
\alias{newKwv}
\alias{addKwv}
\alias{delKwv}
\alias{modVal}
\alias{addComment}
\alias{addHistory}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Modify and edit comments and \code{keyword-value} pairs in FITS header
}
\description{
  Functions to modify and edit \code{keyword = value} pairs in FITS header:
  \code{newKwv} creates \code{keyword = value / comment} line for
    header;
  \code{addKwv} adds \code{keyword = value / comment} to header;
  \code{delKwv} deletes \code{keyword = value / comment} from header;
  \code{modVal} modifies value in \code{keyword = value / comment} in
    header;
  \code{addComment} adds COMMENT line to header;
  \code{addHistory} adds HISTORY line to header.
}
\usage{
newKwv(keyw, val, note)

addKwv(keyw, val, note, headerName)

delKwv(keyw, headerName)

modVal(keyw, val, note, headerName)

addComment(comment, headerName)

addHistory(history, headerName)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{keyw}{
Keyword, 8 character limit (FITS specification)
}
  \item{val}{
Value for keyword
}
  \item{note}{
Optional descriptive note following \code{keyword = value}
}
  \item{comment}{
Comment text string
}
  \item{history}{
History text string
}
  \item{headerName}{
Header card images (vector)
}
}
\details{
All keywords will be converted to upper case (FITS convention) and
truncated to 8 characters.  There is no checking for duplicate keywords.
The default numerical format for values is 20.14g; if other formats are
needed, format separately and write the text string as the value (see
examples).  Similar work-arounds may be necessary for long note
strings (see examples).
}
\value{
  New card image for \code{newKwv}, otherwise modified header card images.
}
\author{
A. Harris
}
\note{
It is also possible to operate directly on the vector of header card
images.  These functions are simply for convenience in maintaining the
correct header formatting.  No \code{END} card is needed in the header card
images; that is added by \code{\link{closeHdr}}, which must be run to
complete the header formatting.
}

\seealso{
\code{\link{readFITS}}, \code{\link{readFITSheader}}, \code{\link{closeHdr}}
}
\examples{
# Make header from scratch, then add, modify, delete card images.
header <- newKwv('KEYWORD', 'VALUE', 'NOTE')
header <- addKwv('test1', 'plot size', header=header)
header <- addKwv('test2', 4294.95397809807, 'number', header=header)
header <- addKwv('test3', 4.29495397809807e50, 'big number', header=header)
header <- addKwv('test4', -4.29495397809807e50, 'big number', header=header)
header <- addKwv('test5', 'this is a very long value', 'number', header=header)
header <- addKwv('test6',
   'this is a very very very very very very very very long value',
   'note', header=header)
header <- addKwv('test7', 'value',
   'very very very very very very very very very very long comment',
   header=header)
header <- addKwv('test8', '0123456789112345678921234567893123456',
   'format long number as string', header=header)
header <- addKwv('apostrophe', 'o\'\'malley',
   'apostrophes are doubled in value strings', header=header)
for (i in 1:4) {
   header <- addKwv(paste('test', 100+i, sep=''), 100+i, header=header)
}
header <- delKwv('test103', header=header)
header <- addComment('TEST103 should be missing from header', header=header)
header <- addHistory('This header generated by modifyHeader example',
   header=header)

# show header
header

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{file}
