% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_users.R
\name{get_users}
\alias{get_users}
\title{Get users data}
\usage{
get_users(gitstats, logins, cache = TRUE, verbose = FALSE)
}
\arguments{
\item{gitstats}{A GitStats object.}

\item{logins}{A character vector of logins.}

\item{cache}{A logical, if set to \code{TRUE} GitStats will retrieve the last
result from its storage.}

\item{verbose}{A logical, \code{TRUE} by default. If \code{FALSE} messages and
printing output is switched off.}
}
\value{
A data.frame.
}
\description{
Get users data
}
\examples{
\dontrun{
 my_gitstats <- create_gitstats() |>
  set_github_host(
    token = Sys.getenv("GITHUB_PAT"),
    orgs = c("r-world-devs")
  ) |>
  set_gitlab_host(
    token = Sys.getenv("GITLAB_PAT_PUBLIC"),
    orgs = "mbtests"
  )
 get_users(my_gitstats, c("maciekabanas", "marcinkowskak"))
}
}
