package de.fhg.iais.kd.djm.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;

import de.fhg.iais.kd.djm.FileTransfer;
import de.fhg.iais.kd.djm.InputFile;
import de.fhg.iais.kd.djm.PerformDocument;

public class Client {

	String ip;
	int port;
	String username;
		
	public Client(String ip, int port, String username){
		this.ip=ip;
		this.port = port;
		this.username = username;
		
	}
	/**
	 * 
	 * @param ip
	 * @param port
	 * @param username
	 * @param id
	 * @throws IOException
	 * @throws InterruptedException
	 */
	public static void waitForResult(String ip, int port, String username, int id) throws IOException, InterruptedException{
		while(true){
			Socket sock = new Socket(ip,port);
			BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
			BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream()));
			
			out.write("<job>\n<username>" + username + "</username>\n<mode>checkResult</mode>\n<id>"+id+"</id>\n</job>\n");
			out.flush();
			String result = in.readLine();
			if(result!=null && (result.contains("job done") || result.contains("Job had an error")))
			{
				System.out.println(result);
				String line="";
				while((line=in.readLine())!=null)
					System.out.println(line);
				break;
			}
			else{
				//System.out.println(result);
				Thread.sleep(2000);
			}
		
			out.close();
			in.close();
			
			sock.close();
		}
	}
	
	public static void deleteJobOnServer(String ip, int port, String username, int id) throws UnknownHostException, IOException{
		Socket sock = new Socket(ip,port);
		BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream()));
		
		out.write("<job>\n<username>"+ username +"</username>\n<mode>deleteFiles</mode>\n<id>"+id+"</id>\n</job>\n");
		out.flush();
		if(in.ready())
			System.err.println(in.readLine());
		in.close();
		out.close();
		sock.close();
	}
	
	/**
	 * 
	 * @param ip
	 * @param port
	 * @param remoteDir
	 * @param inputFiles
	 * @param username
	 * @throws IOException
	 */
	public static void uploadFiles(String ip, int port, String remoteDir,  ArrayList<InputFile> inputFiles, String username) throws IOException{
		Socket sock = new Socket(ip,port);
		DataOutputStream fos = new DataOutputStream(sock.getOutputStream());
		//BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
		DataInputStream in = new DataInputStream(sock.getInputStream());
		String command = "<job>\n<mode>uploadFiles</mode>\n<username>" + username + "</username>\n<remoteDir>" + remoteDir + "</remoteDir>\n";
		for(InputFile inputFile : inputFiles){
			command +="<inputFile>"+inputFile.getFilename() + ":" + new File(inputFile.getFilename()).length() + "</inputFile>\n";
		}
		command +="</job>\n";
		fos.writeBytes(command);
		fos.flush();
		String line="";
		System.out.println("waiting for ok");
		char c;
		while((c=in.readChar())!=-1){
			if(c!='\n'){
				line +=c;
				continue;
			}
			System.out.println(line);
			if(line.equals("ok")){
				line="";
				break;
			}
			line="";
						
		}
		System.out.println("starting uploading file");
		FileTransfer.uploadFiles(fos, inputFiles, username);
		sock.close();
	}
	
	public static void downloadFiles(String ip, int port, String localDir,  ArrayList<InputFile> inputFiles, String username) throws IOException{
		Socket sock = new Socket(ip,port);
		DataOutputStream fos = new DataOutputStream(sock.getOutputStream());
		DataInputStream in = new DataInputStream(sock.getInputStream());
		String command = "<job>\n<mode>downloadFiles</mode>\n<username>" + username + "</username>\n";
		for(InputFile inputFile : inputFiles){
			command +="<inputFile>"+inputFile.getFilename() +"</inputFile>\n";
		}
		command +="</job>\n";
		fos.writeBytes(command);
		fos.flush();

		FileTransfer.receiveSizesAndSave(in, inputFiles);
		FileTransfer.downloadFilesTo(inputFiles, localDir, in);
		sock.close();
	}
}
