% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observedStats.R
\name{observedProb}
\alias{observedLLR}
\alias{observedProb}
\alias{observedU}
\alias{observedX2}
\title{Compute observed statistics for a genotype count matrix}
\usage{
observedProb(c)

observedLLR(c)

observedU(c)

observedX2(c, returnExpected = F)
}
\arguments{
\item{c}{Matrix of observed genotype counts. Each number should be a non-negative integer, and matrix is \eqn{k x k}.}

\item{returnExpected}{Used in \code{observedX2} to indicate whether a matrix of expected numbers should be returned instead.}
}
\value{
the observed statistic
}
\description{
#' Four measures of fit to Hardy-Weinberg for a given set of genotype counts may be computed.
\itemize{
\item \code{observedProb} The probability of the observed set under the HW null and with the allele counts fixed.
\item \code{observedLLR} The log-likelihood ratio of the observed set
\item \code{observedU} The observed U-score. Positive values indicate an excess of homozygotes and negative ones imply too many heterozygotes
\item \code{observedX2} The classical \dQuote{chi-squared} statistic
}
}
\examples{
t <- vec.to.matrix(c(0,3,1,5,18,1,3,7,5,2))
observedStats <- c(observedProb(t), observedLLR(t), observedU(t), observedX2(t))
}

