% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IOHanalyzer.R
\docType{package}
\name{IOHanalyzer}
\alias{IOHanalyzer-package}
\alias{IOHanalyzer}
\title{IOHanalyzer: Data Analysis Part of IOHprofiler}
\description{
The data analysis module for the Iterative Optimization Heuristics Profiler (IOHprofiler).
This module provides statistical analysis methods for the benchmark data generated by
optimization heuristics, which can be visualized through a
web-based interface. The benchmark data is usually generated by the
experimentation module, called IOHexperimenter. IOHanalyzer also supports
the widely used COCO (Comparing Continuous Optimisers) data format for benchmarking.
}
\section{Functions}{

The IOHanalyzer consists of 3 main functionalities:
\itemize{
\item Reading and alligning data from different heuristics, such as IOHExperimenter.
This is done using the \code{\link{DataSet}} and \code{\link{DataSetList}} functions
\item Processing and summarizing this data
\item Creating various plots
}
}

\examples{
path <- system.file("extdata", "ONE_PLUS_LAMDA_EA", package="IOHanalyzer")
dsList <- DataSetList(path)
summary(dsList)
Plot.RT.Single_Func(dsList[1])

\dontrun{
runServer()
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://iohanalyzer.liacs.nl}
  \item \url{https://github.com/IOHprofiler/IOHAnalyzer}
  \item Report bugs at \url{https://github.com/IOHprofiler/IOHAnalyzer/issues}
}

}
\author{
\strong{Maintainer}: Diederick Vermetten \email{d.l.vermetten@liacs.leidenuniv.nl} (\href{https://orcid.org/0000-0003-3040-7162}{ORCID})

Authors:
\itemize{
  \item Hao Wang \email{h.wang@liacs.leidenuniv.nl} (\href{https://orcid.org/0000-0002-4933-5181}{ORCID})
  \item Carola Doerr \email{Carola.Doerr@mpi-inf.mpg.de} (\href{https://orcid.org/0000-0002-4981-3227}{ORCID})
  \item Thomas Bäck \email{t.h.w.baeck@liacs.leidenuniv.nl} (\href{https://orcid.org/0000-0001-6768-1478}{ORCID})
}

}
