% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature.R
\name{track_feature}
\alias{track_feature}
\title{Create a FeatureTrack for a custom JBrowse 2 view}
\usage{
track_feature(track_data, assembly)
}
\arguments{
\item{track_data}{the URL to the GFF3 file}

\item{assembly}{the config string generated by \code{assembly}}
}
\value{
a character vector of stringified FeatureTrack JSON configuration
}
\description{
Creates the necessary configuration string for an
indexed GFF3 file so that it can be used
in a JBrowse custom linear genome view.
}
\details{
It is important to note that while only the GFF3 file is
passed as an argument, \code{tracks_variant} assumes that a GFF3
index of the same name is located with the file

For example:

\code{track_feature("data/features.gff")}

Assumes that \code{data/features.gff.tbi} also exists.

This is a JBrowse 2 convention, and the default naming output of tabix

For more information on creating an index with tabix, visit
\url{https://www.htslib.org/}
}
\examples{
assembly <- assembly("https://jbrowse.org/genomes/hg19/fasta/hg19.fa.gz", bgzip = TRUE)

track_feature("features.gff", assembly)
}
