% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PC2.R
\name{PC2}
\alias{PC2}
\title{Apply the PC method to the Laplace factor model}
\usage{
PC2(data, m)
}
\arguments{
\item{data}{The total data set to be analyzed.}

\item{m}{The number of principal components to retain in the analysis.}
}
\value{
Ahat,Dhat,Sigmahat
}
\description{
This function performs principal component analysis (PCA) on a given data set to reduce dimensionality. It calculates the estimated values for the loadings, specific variances, and the covariance matrix.
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- PC2(data, m)
print(results)
}
