% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LSD.heatscatter.R
\name{heatscatterpoints}
\alias{LSD.heatscatterpoints}
\alias{heatscatterpoints}
\title{A colored scatterplot based on a two-dimensional Kernel Density Estimation (add to an existing plot)}
\usage{
heatscatterpoints(x, y, pch = 19, cexplot = 0.5, nrcol = 30, grid = 100,
  colpal = "heat", simulate = FALSE, daltonize = FALSE, cvd = "p",
  alpha = NULL, rev = FALSE, xlim = NULL, ylim = NULL, only = "none",
  add.contour = FALSE, nlevels = 10, color.contour = "black",
  greyscale = FALSE, log = "", ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{pch}{plotting 'character'. This can either be a single character or an integer code for one of a set of graphics symbols. (see '?pch', to be passed to plot).}

\item{cexplot}{a numerical value giving the amount by which the points should be magnified relative to the default.}

\item{nrcol}{a non-negative integer specifying the number of colors to be used (defaults to 100, if not specified).}

\item{grid}{an integer specifying the size of the grid used for the KDE.}

\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}) (defaults to "heat", if not specified).}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{rev}{logical: if \code{TRUE} (\code{FALSE} by default), a reversed colorpalette is used.}

\item{xlim}{x limits, standard graphics parameter.}

\item{ylim}{y limits, standard graphics parameter.}

\item{only}{a character string which contains 'x' if the density should only be computed for the x axis, 'y' for the y axis (defaults to 'none' for the two-dimensional case).}

\item{add.contour}{logical: if \code{TRUE} (\code{FALSE} by default), the contour lines are added to the plot.}

\item{nlevels}{an integer giving the number of levels of the contour lines.}

\item{color.contour}{R build-in color for the contour lines.}

\item{greyscale}{logical: if \code{TRUE} (\code{FALSE} by default), the used colorpalette is converted to greyscales.}

\item{log}{a character string which contains "x" if the x axis is to be logarithmic, "y" if the y axis is to be logarithmic and "xy" or "yx" if both axes are to be logarithmic.}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
Visualize two dimensional data in a three dimensional fashion facilitating a color encoded Kernel Density Estimation (add to an existing plot).
}
\note{
Two-Dimensional Kernel Density Estimation adapted and modified from Venables and Ripley's MASS package (see reference).
}
\examples{
points = 10^4
x = c(rnorm(points/2),rnorm(points/2)+4)
y = x + rnorm(points,sd=0.8)
x = sign(x)*abs(x)^1.3

plot.new()
plot.window(xlim = c(-5,15),ylim = c(-4,8))
heatscatterpoints(x,y,add.contour=TRUE,color.contour="green",greyscale=TRUE)
axis(1)
axis(2)
box()
}
\author{
Bjoern Schwalb
}
\references{
Venables, W. N. and Ripley, B. D. (2002) \emph{Modern Applied Statistics with S.} Fourth edition. Springer.
}
\seealso{
\code{\link{comparisonplot}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{heatcolors}
\keyword{scatterplot,}

