% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idFunctionsNeg.R
\name{idLPEneg}
\alias{idLPEneg}
\title{Lysophosphoethanolamines (LPE) annotation for ESI-}
\usage{
idLPEneg(
  msobject,
  ppm_precursor = 5,
  ppm_products = 10,
  rttol = 3,
  rt,
  adducts = c("M-H"),
  clfrags = c(140.0115, 196.038, 214.048, "lysope_M-CH3"),
  clrequired = c(F, F, F, "excluding"),
  ftype = c("F", "F", "F", "BB"),
  chainfrags_sn1 = c("fa_M-H"),
  coelCutoff = 0.8,
  dbs,
  verbose = TRUE
)
}
\arguments{
\item{msobject}{an msobject returned by \link{dataProcessing}.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 3 seconds.}

\item{rt}{rt range where the function will look for candidates. By default,
it will search within all RT range in MS1.}

\item{adducts}{expected adducts for LPE in ESI-. Adducts allowed can
be modified in adductsTable (dbs argument).}

\item{clfrags}{vector containing the expected fragments for a given lipid
class. See \link{checkClass} for details.}

\item{clrequired}{logical vector indicating if each class fragment is
required or not. If any of them is required, at least one of them must be
present within the coeluting fragments. See \link{checkClass} for details.}

\item{ftype}{character vector indicating the type of fragments in clfrags.
It can be: "F" (fragment), "NL" (neutral loss) or "BB" (building block).
See \link{checkClass} for details.}

\item{chainfrags_sn1}{character vector containing the fragmentation rules for
the chain fragments. See \link{chainFrags} for details.}

\item{coelCutoff}{coelution score threshold between parent and fragment ions.
Only applied if rawData info is supplied. By default, 0.8.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See \link{createLipidDB}
and \link{assignDB}.}

\item{verbose}{print information messages.}
}
\value{
annotated msobject (list with several elements). The results element
is a data frame that shows: ID, lipid class, CDB (total number of carbons
and double bounds), FA composition (specific chains composition if it has
been confirmed), mz, RT (in seconds), I (intensity), Adducts, ppm (mz error),
confidenceLevel (Subclass, FA level, where chains are known but not their
positions, or FA position level), peakID, and Score (parent-fragment coelution 
score mean in DIA data or relative sum intensity in DDA of all fragments used 
for the identification).
}
\description{
LPE identification based on fragmentation patterns for LC-MS/MS DIA or DDA
data acquired in negative mode.
}
\details{
\code{idLPEneg} function involves 3 steps. 1) FullMS-based
identification of candidate LPE as M-H. 2) Search of
LPE class fragments: 140.0115, 196.038 and 214.048 coeluting with the
precursor ion. If a loss of CH3 group is found coeluting with any candidate,
this will be excluded as it is a characteristic fragment of LPC.3) Search of
specific fragments that confirm chain composition (FA as M-H).

Results data frame shows: ID, lipid class, CDB (total number
of carbons and double bounds), FA composition (specific chains composition if
it has been confirmed), mz, RT (in seconds), I (intensity, which comes
directly from de input), Adducts, ppm (mz error), confidenceLevel (in this
case, as LPE only have one chain, only Subclass and FA level are possible)
and Score (parent-fragment coelution score mean in DIA data or relative 
sum intensity in DDA of all fragments used for the identification).
}
\note{
This function has been writen based on fragmentation patterns
observed for three different platforms (QTOF 6550 from Agilent, Synapt G2-Si
from Waters and Q-exactive from Thermo), but it may need to be customized for
other platforms or acquisition settings.
}
\examples{
\dontrun{
msobject <- idLPEneg(msobject)
}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
