% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{evaluation_metrics}
\alias{evaluation_metrics}
\title{Binary Classification Evaluation}
\usage{
evaluation_metrics(true_labels, pred_labels)
}
\arguments{
\item{true_labels}{An 0-1 or logical vector denoting the true labels. The
meaning of 0 and 1 (or TRUE and FALSE) is up to the user.}

\item{pred_labels}{An 0-1 or logical vector denoting the true labels. The
meaning of 0 and 1 (or TRUE and FALSE) is up to the user.}
}
\value{
A list with the following slots:
  \item{matr}{The confusion matrix built upon true labels and predicted labels.}
  \item{TN}{True negative.}
  \item{FP}{False positive (type I error).}
  \item{FN}{False negative (type II error).}
  \item{TP}{True positive.}
  \item{TPR}{True positive rate (sensitivy).}
  \item{FPR}{False positive rate.}
  \item{TNR}{True negative rate (specificity).}
  \item{FNR}{False negative rate.}
  \item{precision}{Precision or positive predictive value (PPV).}
  \item{accuracy}{Accuracy.}
  \item{error_rate}{Error rate.}
  \item{FDR}{False discovery rate.}
}
\description{
Evaluate the performance of a classification model by comparing its predicted
labels to the true labels. Various metrics are returned to give an insight on
how well the model classifies the observations. This function is added to aid
outlier detection evaluation of MCNM, CNM, MtM, and tM in case that true
outliers are known in advance.
}
\examples{

#++++ Inputs are 0-1 vectors ++++#

evaluation_metrics(
  true_labels = c(1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1),
  pred_labels = c(1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1)
)

#++++ Inputs are logical vectors ++++#

evaluation_metrics(
  true_labels = c(TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, TRUE, FALSE, FALSE),
  pred_labels = c(FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE)
)

}
