% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMcheckDataFile.R
\name{NMcheckDataFile}
\alias{NMcheckDataFile}
\title{check input data based on control stream}
\usage{
NMcheckDataFile(
  file,
  col.row,
  col.id = "ID",
  formats.read = "csv",
  quiet = FALSE,
  file.mod,
  dir.data,
  as.fun,
  use.rds,
  ...
)
}
\arguments{
\item{file}{a model file (input or output control stream)}

\item{col.row}{row identifier}

\item{col.id}{subject identifier}

\item{formats.read}{Prioritized input data file formats to look
for and use if found. Default is c("csv") which means
\code{rds} and \code{fst} will _not_ be used. Typically only
the csv file is wanted because we want to test the input data
as read by Nonmem.}

\item{quiet}{Keep quiet? Default is FALSE.}

\item{file.mod}{How to find the input control stream if you are
using the output control stream.}

\item{dir.data}{The data directory can only be read from the
control stream (.mod) and not from the output file (.lst). So
if you only have the output control stream, use dir.data to
tell in which directory to find the data file. If dir.data is
provided, the .mod file is not used at all.}

\item{as.fun}{The function to run results through before returning
them.}

\item{use.rds}{Deprecated. Use formats.read instead.}

\item{...}{passed to NMcheckData}
}
\value{
A list of diagnostics
}
\description{
Finds input data and checks compatibility with Nonmem control
stream and runs NMcheckData. Don't call this function directly -
use the file argument in NMcheckData instead.
}
\keyword{internal}
