% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlicecdLogNormalPareto.R
\name{dSlicedLNormPareto}
\alias{dSlicedLNormPareto}
\title{The probability density function (pdf) of a Sliced LogNormal Pareto severity distribution}
\usage{
dSlicedLNormPareto(x, mu, sigma, SlicePoint, shape)
}
\arguments{
\item{x}{A positive real number -  the claim amount where the probability density function (pdf) will be evaluated.}

\item{mu}{A real number -  the first parameter of the attritional Claim Severity's LogNormal distribution.}

\item{sigma}{A positive real number -  the second parameter of the attritional Claim Severity's LogNormal distribution.}

\item{SlicePoint}{A positive real number - the slice point and the scale parameter of the Claim Severity's Pareto distribution.}

\item{shape}{A positive real number - the shape parameter of the Claim Severity's Pareto distribution.}
}
\value{
The value of the probability density function (pdf) at \code{x} with an attritional claim LogNormal distribution with parameters \code{mu} and \code{sigma} and a large claim Pareto distribution with parameters \code{SlicePoint} and \code{shape}.
}
\description{
The probability density function (pdf) of a Sliced LogNormal Pareto severity distribution
}
\examples{
dSlicedLNormPareto(1200,6,1.5,1000,1.2)
dSlicedLNormPareto(4000,7,1.6,3000,1.4)
}
