% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConceptSetCounts.R
\name{plotConceptSetCounts}
\alias{plotConceptSetCounts}
\title{Plot the concept counts of a summariseConceptSetCounts output.}
\usage{
plotConceptSetCounts(result, facet = NULL, colour = NULL)
}
\arguments{
\item{result}{A summarised_result object (output of summariseConceptSetCounts).}

\item{facet}{Columns to face by. Formula format can be provided. See possible
columns to face by with: \code{visOmopResults::tidyColumns()}.}

\item{colour}{Columns to colour by. See possible columns to colour by with:
\code{visOmopResults::tidyColumns()}.}
}
\value{
A ggplot2 object showing the concept counts.
}
\description{
Plot the concept counts of a summariseConceptSetCounts output.
}
\examples{
\donttest{
library(dplyr)

cdm <- mockOmopSketch()

result <- summariseConceptSetCounts(
  cdm = cdm,
  conceptSet = list(
    "asthma" = c(4051466, 317009) ,
    "rhinitis" = c(4280726, 4048171, 40486433)
  )
)

result |>
  filter(variable_name == "Number subjects") |>
  plotConceptSetCounts(facet = "codelist_name", colour = "standard_concept_name")

PatientProfiles::mockDisconnect(cdm)
}
}
