% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_image.R
\name{writeImage}
\alias{writeImage}
\title{This function writes 2- or 3-dimensional image (where the third dimension is equal to 3) data to a file}
\usage{
writeImage(data, file_name, ...)
}
\arguments{
\item{data}{a 2- or 3-dimensional object (matrix, data frame or array where the third dimension is equal to 3)}

\item{file_name}{a string specifying the name of the new file}

\item{...}{further arguments for the writePNG, writeJPEG and writeTIFF functions}
}
\value{
a saved image file
}
\description{
This function writes 2- or 3-dimensional image (where the third dimension is equal to 3) data to a file. Supported types are .png, .jpeg, .jpg, .tiff (or .tif, .TIFF, .TIF)
}
\details{
This function takes as input a matrix, data frame or array and saves the data in one of the supported image types ( .png, .jpeg, .jpg, .tiff ).
Extension types similar to .tiff such as .tif, .TIFF, .TIF are also supported
}
\examples{

# path = system.file("tmp_images", "1.png", package = "OpenImageR")

# im = readImage(path)

# writeImage(im, 'new_image.jpeg')

}
