% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOMLRun.R
\name{getOMLRun}
\alias{getOMLRun}
\title{Get an OpenML run.}
\usage{
getOMLRun(run.id, cache.only = FALSE, verbosity = NULL)
}
\arguments{
\item{run.id}{[\code{integer(1)}]\cr
The run ID.}

\item{cache.only}{[\code{logical(1)}]\cr
Only try to retrieve the object from cache.
Will result in error if the object is not found.
Default is \code{FALSE}.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{\link{OMLRun}}].
}
\description{
Given an run id, the corresponding \code{\link{OMLRun}} including all server
and user computed metrics is downloaded if not already available in cache.
}
\examples{
\dontrun{
	runs_ctree = listOMLRuns(flow.id = 2569)
	run1 = getOMLRun(run.id = runs_ctree$run.id[1])
	str(run1, 1)
}
}
\seealso{
Other downloading functions: \code{\link{getOMLDataSetQualities}},
  \code{\link{getOMLDataSet}}, \code{\link{getOMLFlow}},
  \code{\link{getOMLTask}}

Other run-related functions: \code{\link{convertOMLMlrRunToBMR}},
  \code{\link{convertOMLRunToBMR}},
  \code{\link{deleteOMLObject}}, \code{\link{listOMLRuns}},
  \code{\link{makeOMLRunParameter}},
  \code{\link{makeOMLRun}}, \code{\link{tagOMLObject}},
  \code{\link{uploadOMLRun}}
}

