\name{biplotEsa2d}
\alias{biplotEsa2d}
\title{Plot an eigenstructure analysis (ESA) biplot in 2D.}
\usage{biplotEsa2d(x, center=4, g=1, h=1, ...)
}
\description{Plot an eigenstructure analysis (ESA) biplot in 2D. 
The ESA is a special type of biplot suggested by Raeithel (e.g. 1998).
It uses midpoint centering as a default. Note that the eigenstructure analysis
is just a special case of a biplot that can also be produced using the 
\code{\link{biplot2d}} function with the arguments 
\code{center=4, g=1, h=1}.
Here, only the arguments that are modified for the ESA biplot are described.
To see all the parameters that can be changed see \code{\link{biplot2d}}.}
\references{Raeithel, A. (1998). Kooperative Modellproduktion von Professionellen 
und Klienten. Erlaeutert am Beispiel des Repertory Grid.
In A. Raeithel (1998). Selbstorganisation, Kooperation, 
Zeichenprozess. Arbeiten zu einer kulturwissenschaftlichen, 
anwendungsbezogenen Psychologie (p. 209-254). Opladen: 
Westdeutscher Verlag.}
\author{Mark Heckmann}
\seealso{Unsophisticated biplot: \code{\link{biplotSimple}}; \cr
2D biplots:
\code{\link{biplot2d}},
\code{\link{biplotEsa2d}},
\code{\link{biplotSlater2d}};\cr
Pseudo 3D biplots:
\code{\link{biplotPseudo3d}},  
\code{\link{biplotEsaPseudo3d}},
\code{\link{biplotSlaterPseudo3d}};\cr
Interactive 3D biplots:
\code{\link{biplot3d}},
\code{\link{biplotEsa3d}},
\code{\link{biplotSlater3d}};\cr
Function to set view in 3D:
\code{\link{home}}.}
\arguments{\item{x}{\code{repgrid} object.}
\item{center}{Numeric. The type of centering to be performed. 
0= no centering, 1= row mean centering (construct), 
2= column mean centering (elements), 3= double-centering (construct and element means),
4= midpoint centering of rows (constructs).
Eigenstructure analyis uses midpoint centering (\code{4}).}
\item{g}{Power of the singular value matrix assigned to the left singular 
vectors, i.e. the constructs. Eigenstructure analyis uses  
\code{g=1}.}
\item{h}{Power of the singular value matrix assigned to the right singular 
vectors, i.e. the elements. Eigenstructure analyis uses  
\code{h=1}.}
\item{...}{Additional parameters for be passed to \code{\link{biplot2d}}.}
}
\examples{\dontrun{
# See examples in \code{\link{biplot2d}} as the same arguments
# can used for this function.
}}

