% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findAllPaths.R
\name{findAllPaths}
\alias{findAllPaths}
\title{Identifies all paths between all pairs of less than or 
equal to a certain length}
\usage{
findAllPaths(conf, maxLength = 2)
}
\arguments{
\item{conf}{a matrix of conf.mat class. An N-by-N conflict matrix whose \code{(i,j)}th element is the number of times i defeated j.}

\item{maxLength}{a positive numeric integer indicating the maximum length of paths to identify}
}
\value{
A list of two elements. 
 
 \item{direct pathways}{direct pathways found in original matrix}
 
 \item{indirect pathways}{a list of all paths from length 2 to the given length}
}
\description{
\code{findAllPaths} Identifies all paths length less than or equal 
to \code{maxLength} between all pairs of competitors
}
\examples{
# convert an edgelist to conflict matrix
confmatrix <- as.conflictmat(sampleEdgelist)
# find all paths of legnth 3
allp.3 <- findAllPaths(confmatrix, 3)
}
\seealso{
\code{\link{countPaths}} \code{\link{findIDpaths}} \code{\link{transitivity}}
}

